#
# Filename: build_version.sh
# 
# (C) Copyright 2017 Silver Peak Systems, Inc.  
# All rights reserved.
#
# Contains build version information.
#

#
# Setup upgrade.sh hooks for FC6 and earlier platforms
#
# writeimage.sh in FC6 and earlier doesn't look for an upgrade.sh script in the
# image zip. This line tricks writeimage.sh into sourcing upgrade.sh and
# calling upgrade_fc6_writeimage_hooks() as it tries to "slurp in the image's
# build version information"
#
# The checks for EXTRACT_DIR ensures that this only happens when this file is
# sourced from writeimage.sh.
#
[ -n "${EXTRACT_DIR}" ] && [ -f "${EXTRACT_DIR}/upgrade.sh" ] && . ${EXTRACT_DIR}/upgrade.sh && upgrade_fc6_writeimage_hooks && IMAGE_BUILD_UPGRADE=1;

#
# Set the boot parameters to use /boot/initramfs.cpio.gz
#
# New images use an initramfs when booting, however aiset.sh in FC6 doesn't
# set the GRUB initrd option. We trick the FC6 aiset.sh into running this code
# block when it peeks into the ROOT_1 and ROOT_2 partitions to determine their
# build versions. This code block sets the root device to boot by label and
# adds the initrd GRUB option.
#
# The check for BOOT_DISK_DEV_NAME ensures that this only happens when this
# file is sourced from aiset.sh.
#
[ -n "${BOOT_DISK_DEV_NAME}" ] && {
    # Determine which partition we're on (1 or 2)
    bv_partition=
    if [ -z "${mount_options}" ]; then
        # mount_options not set yet, we're being sourced without mounting
        bv_partition=${AIG_THIS_BOOT_ID}
    else
        # mount_options is set, we have been mounted before sourcing
        if [ "${AIG_THIS_BOOT_ID}" == "1" ]; then
            bv_partition=2
        elif [ "${AIG_THIS_BOOT_ID}" == "2" ]; then
            bv_partition=1
        fi
    fi

    # Add initrd to grub menu entry
    if [ "${bv_partition}" == "1" ]; then
        ROOT_DEV_1="LABEL=ROOT_1"
        INITRD_OPTION_1="initrd"
        PATH_INITRD_1="${DIR_BOOT_1}initramfs.cpio.gz"
        sed_grub_args=" \
            -e s,@ROOT_DEV_1@,${ROOT_DEV_1},g \
            -e s,@INITRD_OPTION_1@,${INITRD_OPTION_1},g \
            -e s,@PATH_INITRD_1@,${PATH_INITRD_1},g \
            ${sed_grub_args}"

    elif [ "${bv_partition}" == "2" ]; then
        ROOT_DEV_2="LABEL=ROOT_2"
        INITRD_OPTION_2="initrd"
        PATH_INITRD_2="${DIR_BOOT_2}initramfs.cpio.gz"
        sed_grub_args=" \
            -e s,@ROOT_DEV_2@,${ROOT_DEV_2},g \
            -e s,@INITRD_OPTION_2@,${INITRD_OPTION_2},g \
            -e s,@PATH_INITRD_2@,${PATH_INITRD_2},g \
            ${sed_grub_args}"
    fi
}

#
# Everything below this is auto-generated.
#
BUILD_PROD_NAME="ECOS"
export BUILD_PROD_NAME
BUILD_PROD_PRODUCT="HIDALGO"
export BUILD_PROD_PRODUCT
BUILD_VERSION=""
export BUILD_VERSION
BUILD_MAJ=9
export BUILD_MAJ
BUILD_MIN=5
export BUILD_MIN
BUILD_MAINT=4
export BUILD_MAINT
BUILD_PATCH=0
export BUILD_PATCH
BUILD_DATE="2025-08-07 18:01:34"
export BUILD_DATE
BUILD_REVISION=""
export BUILD_REVISION
BUILD_VARIANT=""
export BUILD_VARIANT
BUILD_PROD_RELEASE=9.5.4.0_103613
export BUILD_PROD_RELEASE
BUILD_HOST_USER=sptest
export BUILD_HOST_USER
BUILD_HOST_MACHINE="yocto-app-build6"
export BUILD_HOST_MACHINE
BUILD_HOST_ARCH_LC="x86_64"
export BUILD_HOST_ARCH_LC
BUILD_ID="#1-dev"
export BUILD_ID
BUILD_PROD_VERSION="ECOS 9.5.4.0_103613 #1-dev 2025-08-07 18:01:34 x86_64 sptest@yocto-app-build6:unknown"
export BUILD_PROD_VERSION
BUILD_GIT_HASH="dabc52adf2ac"
export BUILD_GIT_HASH
BUILD_OS_SDK_VERSION="rel9.5.4.0-2.70"
export BUILD_OS_SDK_VERSION
BUILD_BRANCH_NAME="release/rel9.5.4.0"
export BUILD_BRANCH_NAME
BUILD_PROD_FEATURE_GRUB="2"
export BUILD_PROD_FEATURE_GRUB
BUILD_DEBUG="0"
export BUILD_DEBUG
BUILD_SB_SIGN="1"
export BUILD_SB_SIGN
BUILD_SB_SK="1"
export BUILD_SB_SK
BUILD_HPE_CSS="prod"
export BUILD_HPE_CSS
